﻿'*****************************************************************************
' Volt Meter 2020.06.16
'*****************************************************************************
Public Class Form1
    Dim voltmeter_file_name As String = ""
    Dim data1 As String = ""
    Dim data2 As String = ""
    Dim data3 As String = ""
    Dim volt_data As String = ""
    Dim volt_val As Double = 0
    Dim volt_val_1 As Double = 0
    Dim volt_val_2 As Double = 0
    Dim volt_val2 As Double = 0
    Dim d1 As Double = 0
    Dim i1 As Integer = 0
    Dim i2 As Integer = 0
    Dim i3 As Integer = 0
    Dim i4 As Integer = 0
    Dim i5 As Integer = 0
    Dim i6 As Integer = 0
    Dim w_meter7_x As Integer
    Dim w_meter7_y As Integer
    Dim w_second As Integer
    Dim w_minute As Integer
    Dim w_hour As Integer
    Dim w_start_timer As Integer = 0
    Dim w_start_f As Integer = 0
    Dim w_counter1 As Integer = 0
    Dim w_counter2 As Integer = 0
    Dim w_fileout_time As Integer = 0
    Dim w_osc(1000) As Double
    Dim w_osc_counter As Integer = 0
    Dim w_osc_counter2 As Integer = 0
    Dim w_ref_volt As Double
    Dim w_max As Double = 0
    Dim w_min As Double = 99
    Dim w_ave As Double = 0
    Dim w_ave_count As Integer = 0
    Dim w_hist(100) As Integer
    Dim w_hist_counter As Integer = 0
    Dim w_hist_sample_c As Integer = 0
    Dim w_stopwatch As Double

    '*****************************************************************************
    ' [START] Button1_Click
    '*****************************************************************************
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        If w_start_f = 0 Then
            w_start_f = 1
            w_ref_volt = Val(ToolStripComboBox1.Text)
            If ToolStripComboBox4.Text = "ON" Then
                voltmeter_file_name = DateString + "_" + Mid(TimeString, 1, 2) +
                Mid(TimeString, 4, 2) + Mid(TimeString, 7, 2) + ".csv"
                FileSystem.FileOpen(1, voltmeter_file_name, OpenMode.Output)
            End If
            SerialPort1.PortName = ToolStripComboBox2.Text
            SerialPort1.Open()
            Button1.BackColor = Color.LightPink
            Label2.BackColor = Color.DarkGreen
            PictureBox1.Visible = True
            LineShape1.Visible = True
            LineShape2.Visible = True
            LineShape3.Visible = True
            w_fileout_time = Val(ToolStripComboBox3.Text) * 17
            FileSystem.FileOpen(2, "voltmeter.ini", OpenMode.Output)
            FileSystem.PrintLine(2, "[PARAMETER]")
            FileSystem.PrintLine(2, "COM=" + ToolStripComboBox2.Text)
            FileSystem.PrintLine(2, "INTERVAL=" + ToolStripComboBox3.Text)
            FileSystem.PrintLine(2, "REFVOLT=" + ToolStripComboBox1.Text)
            FileSystem.PrintLine(2, "LOGGING=" + ToolStripComboBox4.Text)
            FileSystem.FileClose(2)
            ToolStripComboBox1.Enabled = False
            ToolStripComboBox2.Enabled = False
            ToolStripComboBox3.Enabled = False
            ToolStripComboBox4.Enabled = False
            Button1.Text = "STOP"
            For i1 = 1 To 100
                w_hist(i1) = 0
            Next
            w_hist_counter = 0
            w_hist_sample_c = 0
            w_stopwatch = Stopwatch.GetTimestamp
        Else
            If w_start_f = 3 Then   ' STOP
                w_start_f = 2
                Label3.Text = ""
                Label3.ForeColor = Color.Blue
                Label3.Text = "Holding ..."
                Button1.Text = "RESTART"
            Else
                If w_start_f = 2 Then   ' RESTART
                    w_start_f = 1
                    Button1.Text = "STOP"
                    w_max = 0
                    w_min = 99
                    w_ave_count = 0
                    w_ave = 0
                    For i1 = 1 To 100
                        w_osc(i1) = -1
                    Next
                    For i1 = 1 To 100
                        w_hist(i1) = 0
                    Next
                    w_hist_counter = 0
                    w_hist_sample_c = 0
                    w_stopwatch = Stopwatch.GetTimestamp
                End If
            End If
        End If
    End Sub

    '*****************************************************************************
    ' 50msec 毎 Timer
    '*****************************************************************************
    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        ' プログラムの最初の１回だけ（ここから）**********************************
        If w_start_timer = 0 Then
            w_start_timer = 1
            If System.IO.File.Exists("voltmeter.ini") = False Then
                FileSystem.FileOpen(2, "voltmeter.ini", OpenMode.Output)
                FileSystem.PrintLine(2, "[PARAMETER]")
                FileSystem.PrintLine(2, "COM=COM1")
                FileSystem.PrintLine(2, "INTERVAL=1.0")
                FileSystem.PrintLine(2, "REFVOLT=5.0")
                FileSystem.PrintLine(2, "LOGGING=OFF")
                FileSystem.FileClose(2)
            End If
            FileSystem.FileOpen(2, "voltmeter.ini", OpenMode.Input)
            data1 = FileSystem.LineInput(2)
            data1 = FileSystem.LineInput(2)
            ToolStripComboBox2.Text = Mid(data1, 5, 5)
            data1 = FileSystem.LineInput(2)
            ToolStripComboBox3.Text = Mid(data1, 10, 5)
            data1 = FileSystem.LineInput(2)
            ToolStripComboBox1.Text = Mid(data1, 9, 3)
            data1 = FileSystem.LineInput(2)
            ToolStripComboBox4.Text = Mid(data1, 9, 3)
            FileSystem.FileClose(2)
            For i1 = 1 To 100
                w_osc(i1) = -1
            Next
        End If
        ' プログラムの最初の１回だけ（ここまで）**********************************

        If w_start_f = 3 Then

            '経過時間の表示 *******************************
            i1 = Int((Stopwatch.GetTimestamp - w_stopwatch) / 10000000)
            w_second = i1 Mod 60
            i3 = i1 \ 60
            w_minute = i3 Mod 60
            w_hour = i3 \ 60
            If w_second < 10 Then
                data1 = " 0" + Mid(Str(w_second), 2, 1)
            Else
                data1 = Str(w_second)
            End If
            If w_minute < 10 Then
                data2 = " 0" + Mid(Str(w_minute), 2, 1)
            Else
                data2 = Str(w_minute)
            End If
            Label16.Text = "Lap time  " + Str(w_hour) + " :" + data2 + " :" + data1

            '電圧計デジタル表示 ***************************
            data2 = Mid(Str(volt_val), 2, 5)
            If volt_val < 1 Then data2 = "0" + Mid(data2, 1, 4)
            If Len(data2) = 4 Then data2 = data2 + "0"
            If Len(data2) = 3 Then data2 = data2 + "00"
            If Len(data2) = 2 Then data2 = data2 + "000"
            If Len(data2) = 1 Then data2 = data2 + ".000"
            If volt_val = 0 Then data2 = "0.000"
            volt_data = data2
            Label2.Text = " " + volt_data

            '電圧計　針メーターの表示 *********************
            volt_val2 = (volt_val + volt_val2 * 3) / 4
            LineShape1.X1 = 193 - 165 * Math.Sin(-(volt_val2 - 2.5) / 7.7 * 3.1415)
            LineShape1.Y1 = 404 - 165 * Math.Cos(-(volt_val2 - 2.5) / 7.7 * 3.1415)
            LineShape1.X2 = LineShape1.X1 - (LineShape1.X1 - 193) * (LineShape1.Y1 - 389) / (LineShape1.Y1 - 404)
            LineShape1.Y2 = 389
            LineShape1.Hide()
            PictureBox1.Refresh()
            PictureBox1.SendToBack()
            LineShape1.Show()

            ' オシロスコープの表示 ************************
            w_osc_counter = w_osc_counter + 1
            w_osc_counter2 = w_osc_counter2 + 1
            If w_osc_counter > 11 Then w_osc_counter = 0
            If w_osc_counter2 > 24 Then w_osc_counter2 = 0
            If w_osc_counter = 1 Then
                For i1 = 1 To 99
                    w_osc(101 - i1) = w_osc(100 - i1)
                Next
                w_osc(1) = volt_val
            End If
            If w_osc_counter2 = 1 Then
                PictureBox3.Refresh()
                PictureBox3.SendToBack()
                For i1 = 1 To 60 Step 3
                    If w_osc(i1 + 1) >= 0 Then
                        LineShape2.X1 = 707 - i1 * 5 + 5
                        LineShape2.Y1 = 195 - (w_osc(i1) / 5 * 133)
                        LineShape2.X2 = 707 - i1 * 5
                        LineShape2.Y2 = 195 - (w_osc(i1 + 1) / 5 * 133)
                        LineShape2.Update()
                    End If
                Next
                For i1 = 2 To 60 Step 3
                    If w_osc(i1 + 1) >= 0 Then
                        LineShape2.X1 = 707 - i1 * 5 + 5
                        LineShape2.Y1 = 195 - (w_osc(i1) / 5 * 133)
                        LineShape2.X2 = 707 - i1 * 5
                        LineShape2.Y2 = 195 - (w_osc(i1 + 1) / 5 * 133)
                        LineShape2.Update()
                    End If
                Next
                For i1 = 3 To 60 Step 3
                    If w_osc(i1 + 1) >= 0 Then
                        LineShape2.X1 = 707 - i1 * 5 + 5
                        LineShape2.Y1 = 195 - (w_osc(i1) / 5 * 133)
                        LineShape2.X2 = 707 - i1 * 5
                        LineShape2.Y2 = 195 - (w_osc(i1 + 1) / 5 * 133)
                        LineShape2.Update()
                    End If
                Next
            End If

            'ログファイルへの出力 *************************
            If ToolStripComboBox4.Text = "ON" Then
                w_counter2 = w_counter2 + 1
                If w_counter2 > w_fileout_time Then w_counter2 = 0
                If w_counter2 = 1 Then
                    FileSystem.Print(1, DateString)
                    FileSystem.Print(1, ",")
                    FileSystem.Print(1, TimeString)
                    FileSystem.Print(1, ",")
                    FileSystem.Print(1, volt_data)
                    FileSystem.PrintLine(1, ",")
                End If
            End If

            'Max Min Ave の表示 ***************************
            If volt_val > w_max Then w_max = volt_val
            If volt_val < w_min Then w_min = volt_val
            data3 = Mid(Str(w_max), 2, 5)
            If w_max < 1 Then data3 = "0" + Mid(data3, 1, 4)
            If w_max = 0 Then data3 = "0.000"
            If Len(data3) = 1 Then data3 = data3 + ".000"
            If Len(data3) = 2 Then data3 = data3 + "000"
            If Len(data3) = 3 Then data3 = data3 + "00"
            If Len(data3) = 4 Then data3 = data3 + "0"
            Label6.Text = data3
            data3 = Mid(Str(w_min), 2, 5)
            If w_min < 1 Then data3 = "0" + Mid(data3, 1, 4)
            If w_min = 0 Then data3 = "0.000"
            If Len(data3) = 1 Then data3 = data3 + ".000"
            If Len(data3) = 2 Then data3 = data3 + "000"
            If Len(data3) = 3 Then data3 = data3 + "00"
            If Len(data3) = 4 Then data3 = data3 + "0"
            Label7.Text = data3
            w_ave = (w_ave * w_ave_count + volt_val) / (w_ave_count + 1)
            w_ave_count = w_ave_count + 1
            data3 = Mid(Str(w_ave), 2, 5)
            If w_ave < 1 Then data3 = "0" + Mid(data3, 1, 4)
            If w_ave = 0 Then data3 = "0.000"
            If Len(data3) = 1 Then data3 = data3 + ".000"
            If Len(data3) = 2 Then data3 = data3 + "000"
            If Len(data3) = 3 Then data3 = data3 + "00"
            If Len(data3) = 4 Then data3 = data3 + "0"
            Label11.Text = data3

            'Histgramの表示 *******************************
            w_hist_counter = w_hist_counter + 1
            If w_hist_counter > 10 Then w_hist_counter = 0
            If w_hist_counter = 1 Or 4 Or 7 Or 13 Or 17 Then
                w_hist_sample_c = w_hist_sample_c + 1
                i1 = volt_val / 0.1 + 1
                w_hist(i1) = w_hist(i1) + 1
                Label15.Text = "Sample : " + Str(w_hist_sample_c)
            End If
            If w_hist_counter = 1 Then
                PictureBox4.SendToBack()
                Dim bmp_meter7 = New Bitmap("meter7.jpg")
                Dim g As Graphics = PictureBox4.CreateGraphics()
                For i1 = 1 To 50 Step 1
                    LineShape3.X1 = 400 + i1 * 6
                    LineShape3.Y1 = 370
                    LineShape3.X2 = 400 + i1 * 6
                    d1 = w_hist(i1) / w_hist_sample_c * 4
                    If d1 > 1 Then d1 = 1
                    LineShape3.Y2 = 370 - d1 * 128
                    w_meter7_x = 7 + i1 * 6
                    w_meter7_y = 129 - d1 * 128
                    Dim rect As New Rectangle(w_meter7_x, 8, 7, w_meter7_y)
                    g.DrawImage(bmp_meter7, w_meter7_x, 8, rect, GraphicsUnit.Pixel)
                    '    g.Dispose()
                    If w_hist(i1) > 0 Then
                        LineShape3.Update()
                    End If
                Next
            End If

            'Runningの表示 ********************************
            w_counter1 = w_counter1 + 1
            If w_counter1 > 35 Then w_counter1 = 0
            Label3.ForeColor = Color.Red
            If w_counter1 = 1 Then Label3.Text = " R"
            If w_counter1 = 3 Then Label3.Text = " Ru"
            If w_counter1 = 5 Then Label3.Text = " Run"
            If w_counter1 = 7 Then Label3.Text = " Runn"
            If w_counter1 = 9 Then Label3.Text = " Runni"
            If w_counter1 = 11 Then Label3.Text = " Runnin"
            If w_counter1 = 13 Then Label3.Text = " Running"
            If w_counter1 = 15 Then Label3.Text = " Running ."
            If w_counter1 = 17 Then Label3.Text = " Running . ."
            If w_counter1 = 19 Then Label3.Text = " Running . . ."
            If w_counter1 = 30 Then Label3.Text = ""
        End If

    End Sub

    '*****************************************************************************
    ' RS232C から受信した時
    '*****************************************************************************
    Private Sub comreceiv(sender As Object, e As IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived
        data1 = SerialPort1.ReadLine()
        If w_start_f = 1 Then w_start_f = 3
        volt_val_2 = volt_val_1
        volt_val_1 = volt_val
        volt_val = 0
        '    w_ref_volt = 5.0 'ADC Full scale i.e. VDD Voltage of PIC16F88
        If Mid(data1, 1, 1) = "1" Then volt_val = volt_val + w_ref_volt / 2
        If Mid(data1, 2, 1) = "1" Then volt_val = volt_val + w_ref_volt / 4
        If Mid(data1, 3, 1) = "1" Then volt_val = volt_val + w_ref_volt / 8
        If Mid(data1, 4, 1) = "1" Then volt_val = volt_val + w_ref_volt / 16
        If Mid(data1, 5, 1) = "1" Then volt_val = volt_val + w_ref_volt / 32
        If Mid(data1, 6, 1) = "1" Then volt_val = volt_val + w_ref_volt / 64
        If Mid(data1, 7, 1) = "1" Then volt_val = volt_val + w_ref_volt / 128
        If Mid(data1, 8, 1) = "1" Then volt_val = volt_val + w_ref_volt / 256
        If Mid(data1, 9, 1) = "1" Then volt_val = volt_val + w_ref_volt / 512
        If Mid(data1, 10, 1) = "1" Then volt_val = volt_val + w_ref_volt / 1024
        volt_val = (volt_val + volt_val_1 + volt_val_2) / 3
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load

    End Sub
End Class
